﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class TileAudio : MonoBehaviour
{
    [Serializable]
    public struct TileAudios
    {
        public Sprite TileSprite;
        public AudioClip MovementAudioClip;
    }

    public TileAudios[] AudioClips;
    private AudioSource _MovementAudioSource;
    private string _CurrentTileName;

    /// <summary>
    /// Plays the audio file associated with movement on the specified tile
    /// </summary>
    /// <param name="tileName">The name of the tile</param>
    public void PlayTileAudio(string tileName)
    {
        if(_MovementAudioSource != null && _MovementAudioSource.isPlaying && AudioManager.Instance != null && _CurrentTileName != tileName)
        {
            PlayMovementAudio(tileName);
        }

        else if ((_MovementAudioSource == null || !_MovementAudioSource.isPlaying) && AudioManager.Instance != null)
        {
            PlayMovementAudio(tileName);
        }
    }

    /// <summary>
    /// Tries to fade out the movement audio source, used when player stops moving
    /// </summary>
    public void TryFadeOutTileAudio()
    {
        if(_MovementAudioSource != null && _MovementAudioSource.isPlaying)
        {
            AudioManager.Instance.FadeOutAudioSource(_MovementAudioSource, 1000.0f);
            _MovementAudioSource = null;
        }
    }

    /// <summary>
    /// Loops through, and plays the movement audio for the specified tile if it exists
    /// </summary>
    /// <param name="tileName">The name of tile to play audio for</param>
    private void PlayMovementAudio(string tileName)
    {
        foreach (TileAudios audios in AudioClips)
        {
            if (audios.TileSprite.name == tileName)
            {
                //Found it, so update the current tile, and play the movement audio for the tile
                _CurrentTileName = tileName;
                _MovementAudioSource = AudioManager.Instance.PlaySFX(audios.MovementAudioClip);
                break;
            }
        }
    }
}
